/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.enchantments;

import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;

public class EnchantmentAgility
extends Enchantment {
    public static final UUID speedModifier = UUID.fromString("e6107045-134f-4c54-a645-75c3ae5c7a27");

    public EnchantmentAgility() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_LEGS, new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS});
        this.setRegistryName("agility");
        this.func_77322_b("mujmajnkraftsbettersurvival.agility");
    }

    public static void applySpeedModifier(EntityLivingBase entity, int level) {
        if (level > 0) {
            double d = 0.01 * (double)level;
            AttributeModifier modifier = new AttributeModifier(speedModifier, "agility", d, 0);
            IAttributeInstance speed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (!speed.func_180374_a(modifier)) {
                speed.func_111121_a(modifier);
            } else if (speed.func_111127_a(speedModifier).func_111164_d() != d) {
                speed.func_188479_b(speedModifier);
                speed.func_111121_a(modifier);
            }
        }
    }

    public int func_77325_b() {
        return ForgeConfigHandler.enchantments.agilityLevel;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public boolean func_185261_e() {
        return ForgeConfigHandler.enchantments.agilityTreasure;
    }

    public boolean isAllowedOnBooks() {
        return ForgeConfigHandler.enchantments.agilityLevel != 0;
    }
}

